#include <iostream>
#include <vector>
#include <algorithm>
#include <map>

using namespace std;

map<vector<int>, int> zapamceno;

bool je_sortiran(const vector<int>& niz) {
    for (size_t i = 0; i < niz.size() - 1; ++i) {
        if (niz[i] > niz[i + 1]) {
            return false;
        }
    }
    return true;
}

int resi(vector<int> niz) {
    if (je_sortiran(niz)) {
        return 0;
    }
    if (zapamceno.count(niz)) {
        return zapamceno[niz];
    }
    int n = niz.size();
    if (n <= 1) {
        return 0;
    }
    int min_cena = 1e9;
    for (int i = 0; i < (1 << n); ++i) {
        vector<int> s1, s2;
        for (int j = 0; j < n; ++j) {
            if ((i >> j) & 1) {
                s1.push_back(niz[j]);
            } else {
                s2.push_back(niz[j]);
            }
        }
        if (!s1.empty() && !s2.empty()) {
            min_cena = min(min_cena, 1 + resi(s1) + resi(s2));
        }
    }
    return zapamceno[niz] = min_cena;
}

int main() {
    int n, q;
    cin >> n >> q;
    vector<int> p(n);
    for (int i = 0; i < n; ++i) {
        cin >> p[i];
    }
    zapamceno.clear();
    cout << resi(p) << endl;
    for (int k = 0; k < q; ++k) {
        int i, j;
        cin >> i >> j;
        swap(p[i - 1], p[j - 1]);
        zapamceno.clear();
        cout << resi(p) << endl;
    }
    return 0;
}